#region References

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using gov.va.med.vbecs.Common;
using Action = System.Action;

#endregion

namespace gov.va.med.vbecs.GUI.controls
{
	#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/4/2002</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary></summary>

		#endregion

	[
		DefaultEvent("Click"),
	]
	public class VbecsButton : GUI.controls.BaseControl , IButtonControl
	{
		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.btnOK = new System.Windows.Forms.Button();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.SuspendLayout();
			// 
			// btnOK
			// 
			this.btnOK.Dock = System.Windows.Forms.DockStyle.Fill;
			this.btnOK.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.btnOK.Name = "btnOK";
			this.btnOK.TabIndex = 0;
			this.btnOK.Text = "&OK";
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			this.btnOK.MouseHover += new System.EventHandler(this.btnOK_MouseHover);
			// 
			// toolTip1
			// 
			this.toolTip1.ShowAlways = true;
			// 
			// VbecsButton
			// 
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.btnOK});
			this.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Name = "VbecsButton";
			this.Size = new System.Drawing.Size(75, 23);
			this.ForeColorChanged += new System.EventHandler(this.VbecsButton_ForeColorChanged);
			this.SizeChanged += new System.EventHandler(this.VbecsButton_SizeChanged);
			this.FontChanged += new System.EventHandler(this.VbecsButton_FontChanged);
			this.BackColorChanged += new System.EventHandler(this.VbecsButton_BackColorChanged);
			this.ResumeLayout(false);

		}
		#endregion
		
		#region Controls

		private System.Windows.Forms.Button btnOK;
		private System.ComponentModel.IContainer components;
		private System.Windows.Forms.ToolTip toolTip1;
		
		#endregion

		#region Variables
		
		private bool _rowVerionTripped = false;

		private System.EventHandler onClick;

		#endregion

		#region Events	

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		/// <summary>
		/// On paint event handler
		/// </summary>
		/// <param name="pe">Paint event args</param>
		protected override void OnPaint(PaintEventArgs pe)
		{
			base.OnPaint(pe);
			PaintOKButton();
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		/// <summary>
		/// Button click event
		/// </summary>
		new public event EventHandler Click
		{
			add 
			{ 
				onClick += value; 
			}
			remove 
			{ 
				onClick -= value; 
			}
		}

		/// <summary>
		/// Handles the size changed event
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void VbecsButton_SizeChanged(object sender, System.EventArgs e)
		{
			PaintOKButton();
		}

		/// <summary>
		/// Handles the back color changed event
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void VbecsButton_BackColorChanged(object sender, System.EventArgs e)
		{
			PaintOKButton();
		}

		/// <summary>
		/// Handles the font changed event
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void VbecsButton_FontChanged(object sender, System.EventArgs e)
		{
			PaintOKButton();
		}

		/// <summary>
		/// Handles the fore color changed event
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void VbecsButton_ForeColorChanged(object sender, System.EventArgs e)
		{
			PaintOKButton();
		}

		/// <summary>
		/// Handles the ok button clicked event
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();
			//CR 2791 added check of the EnabledButton flag
			if (onClick!=null && this.EnabledButton == true) onClick(sender,e);
		}

		/// <summary>
		/// Handles the mouse hover event
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnOK_MouseHover(object sender, System.EventArgs e)
		{
			this.OnMouseHover(e);
		}

		#endregion

		#region Constructors

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/4/2002</CreationDate>
		/// <summary>
		/// Constructor
		/// </summary>
		public VbecsButton()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Properties

		/// <newpara> Property Name: Text</newpara>
		/// <newpara> Property Type: String</newpara>
		/// <newpara> Developers: Cameron Taylor</newpara>
		/// <newpara> Site Name: Hines OIFO </newpara>
		/// <newpara> Date Created: 7/17/2002</newpara>
		/// <summary> Description: The text contained in the control. Editable at design time</summary>
		[
		Category("Appearance"),
		Description("The text contained in the control"),
		DefaultValue("&OK"),
		Bindable(false),
		Browsable(true),
		]
		override public string Text
		{
			get
			{
				return btnOK.Text;
			}
			set
			{
                //CR3414
			    if (InvokeRequired)
			    {
                    BeginInvoke(new Action(() =>
                    {
                        btnOK.Text = value;
                        Refresh();
                    }));
			    }
			    else
			    {
                    btnOK.Text = value;
                    Refresh(); 
			    }
			}
		}

		/// <newpara> Property Name: Dock</newpara>
		/// <newpara> Property Type: DockStyle</newpara>
		/// <newpara> Developers: Cameron Taylor</newpara>
		/// <newpara> Site Name: Hines OIFO </newpara>
		/// <newpara> Date Created: 4/29/2002</newpara>		
		/// <summary> Description: Dock property override. May be edited at design time</summary>
		[Browsable(true)]
		public override DockStyle Dock 
		{
			get { return base.Dock; }
			set { base.Dock = value; }
		}

		/// <newpara> Property Name: Anchor</newpara>
		/// <newpara> Property Type: AnchorStyles</newpara>
		/// <newpara> Developers: Cameron Taylor</newpara>
		/// <newpara> Site Name: Hines OIFO </newpara>
		/// <newpara> Date Created: 4/29/2002</newpara>
		/// <summary> Description: Anchor property override. May be edited at design time</summary>
		[Browsable(true)]
		public override AnchorStyles Anchor
		{
			get { return base.Anchor; }
			set { base.Anchor = value; }
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		/// <summary>
		/// Gets or sets button enabled indicator. Replaces enabled property
		/// </summary>
		[
		Category("Behavior"),
		Description("Indicates whether the button is enabled"),
		DefaultValue(true),
		Bindable(true),
		Browsable(true),
		]
		public bool EnabledButton
		{
			get 
			{ 
				return btnOK.Visible; 
			}
			set 
			{ 
				if(value)
				{
					if(!this.RowVersionException)		//CR2077
					{
						btnOK.Visible = value; 
					}
				}
				else
				{
					btnOK.Visible = value; 
				}
				this.Refresh();
			}
		}

		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/02/2006</CreationDate>
		/// <summary>
		/// Gets or sets button enabled indicator. Replaces enabled property
		/// This property was added to circumvent UC code that sets the button enabled property during a OnValid event.
		/// If RowVersion fires, the business object is still valid, and user code may check for broken rules count and enable
		/// the button to save.  To prevent this horrible, vicious cycle, _rowVersionTripped will be checked in the EnabledButton property.
		/// CR2077
		/// </summary>
		[
		Category("Behavior"),
		Description("Indicates whether the row version was tripped, "),
		DefaultValue(false),
		Bindable(true),
		Browsable(true),
		]
		public bool RowVersionException
		{
			get 
			{ 
				return this._rowVerionTripped;
			}
			set 
			{ 
				if (value)
				{
					this._rowVerionTripped = true;
					this.SetToolTip( StrRes.Tooltips.Common.DataWasNotSavedBecauseOfRowversionViolation().ResString );
					this.EnabledButton = false;
				}
				else
				{
					this._rowVerionTripped = false;
				}
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		/// <summary>
		/// Gets or sets dialog result produced in a modal form by clicking the button
		/// </summary>
		[
		Category("Behavior"),
		Description("The dialog result produced in a modal form by clicking the button"),
		DefaultValue(DialogResult.None),
		Bindable(false),
		Browsable(true),
		]
		public DialogResult DialogResult
		{
			get
			{
				return btnOK.DialogResult;
			}
			set
			{
				btnOK.DialogResult = value;
			}
		}

		/// <summary>
		/// The image that will be displayed on the face of the control"
		/// </summary>
		[
		Category("Appearance"),
		Description("The image that will be displayed on the face of the control"),
		Bindable(false),
		Browsable(true),
		]
		public System.Drawing.Image Image
		{
			get
			{
				return btnOK.Image;
			}
			set
			{
				btnOK.Image = value;
				this.Refresh();
			}
		}

		#endregion

		#region Methods

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		///
		/// <summary>
		/// Public method, required to support IButtonControl, notifies a control that it is the default button so that its appearance and behavior is adjusted accordingly
		/// </summary>
		/// <param name="value">Default indicator</param>
		public void NotifyDefault(bool value)
		{
			this.btnOK.NotifyDefault(value);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/16/2003</CreationDate>
		///
		/// <summary>
		/// Public method, required to support IButtonControl, generates a Click event for a button
		/// </summary>
		public void PerformClick()
		{
			if ((this.Visible) && (this.EnabledButton))
			{
				this.btnOK_Click(null,EventArgs.Empty);
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <returns></returns>
		public string GetToolTip()
		{
			string currentToolTip = this.toolTip1 != null ? this.toolTip1.GetToolTip(this) : null;
			//
			return currentToolTip == null ? string.Empty : currentToolTip;
		}
		
		/// <summary>
		/// Public method to set the tool tip text that appears when mouse hovers over the control
		/// </summary>
		/// <param name="caption">Tool tip text to display</param>
		public void SetToolTip(string caption)
		{
			string finalcaption = caption;	//deafult, assume rowversion isn't tripped
			
			//If rowversion has been tripped, this is the only caption we want set, CR2077
			if (this._rowVerionTripped)
			{
				finalcaption = StrRes.Tooltips.Common.DataWasNotSavedBecauseOfRowversionViolation().ResString;
			}

			//Trying to avoid tooltip "flicker"
			if (finalcaption != this.toolTip1.GetToolTip(this))
			{
				//CR 2837 - Wrapping SetToolTip() with Active flag setting to avoid tooltip pop-ups without mouse hovering
				this.toolTip1.Active = false;
				this.toolTip1.SetToolTip(this.btnOK,finalcaption);
				this.toolTip1.SetToolTip(this,finalcaption);
				this.toolTip1.Active = true;
			}
		}


		/// <summary>
		/// Paints the button
		/// </summary>
		private void PaintOKButton()
		{
			//
			using (Graphics g = this.CreateGraphics())
			{
                //
				Rectangle darkdarkRect = new Rectangle(new Point(0,0),new Size(this.Width,this.Height));
				Rectangle darkRect = new Rectangle(new Point(0,0), new Size(this.Width-1,this.Height-1));
				Rectangle lightRect = new Rectangle(new Point(0,0), new Size(this.Width-2,this.Height-2));
				Rectangle mainRect = new Rectangle(new Point(1,1), new Size(this.Width-3,this.Height-3));
				//
                g.FillRectangle(new SolidBrush(Color.FromKnownColor(KnownColor.ControlDarkDark)), darkdarkRect);
              	g.FillRectangle(new SolidBrush(Color.FromKnownColor(KnownColor.ControlDark)),darkRect);
				g.FillRectangle(new SolidBrush(Color.FromKnownColor(KnownColor.ControlLightLight)),lightRect);
				g.FillRectangle(new SolidBrush(Color.FromKnownColor(KnownColor.Control)),mainRect);
				//
				StringFormat strCenter = new StringFormat();
				strCenter.Alignment = StringAlignment.Center;
				//
				Rectangle textRect = new Rectangle(new Point(0,4),new Size(this.Width,16));
				Rectangle textShadowRect = new Rectangle(new Point(1,5),new Size(this.Width-1,16));
				g.DrawString(btnOK.Text.Replace("&",""),this.Font,new SolidBrush(Color.FromKnownColor(KnownColor.ControlLightLight)),textShadowRect,strCenter);
				g.DrawString(btnOK.Text.Replace("&",""),this.Font,new SolidBrush(Color.FromKnownColor(KnownColor.GrayText)),textRect,strCenter);
			}

		}

		#endregion
	}
}
